package mcfall.raytracer;

import java.awt.image.WritableRaster;
import java.util.Observable;

/**
 * The Class rayTracerBatches.
 */
public class RayTracerBatch extends Thread {

	/** The end row. */
	int startColumn, startRow,endColumn, endRow;
	
	/** The localraster. */
	WritableRaster localraster;
	RayTracer rayTracer;
	/**
	 * Instantiates a new ray tracer batches.
	 * 
	 * @param raster the raster
	 * @param startColumn the start column
	 * @param startRow the start row
	 * @param endColumn the end column
	 * @param endRow the end row
	 */
	public RayTracerBatch(RayTracer rayTracer, WritableRaster raster, int startColumn,int startRow,int endColumn, int endRow)
	{
		this.startColumn = startColumn;
		this.startRow = startRow;
		this.endColumn = endColumn;
		this.endRow = endRow;
		this.localraster = raster;
		this.rayTracer=rayTracer;
	}

	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	@Override
	public void run() {
		this.setPriority(Thread.MAX_PRIORITY);
		rayTracer.startProduction(this.localraster, startColumn, startRow, endColumn, endRow);
	}
}
